<?php
/*
*	Post Meta About Author
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$author_info_link_text = impeka_grve_option( 'post_author_info_link_text' );

?>
<div id="grve-about-author-section" data-header-color="default" class="grve-padding-top-3x grve-padding-bottom-3x">
	<div class="grve-container">
		<div id="grve-about-author">
			<div class="grve-author-image">
				<?php echo get_avatar( get_the_author_meta('ID'), 90 ); ?>
			</div>
			<div class="grve-author-info">
				<h2 class="grve-title grve-h3"><?php the_author_link(); ?></h2>
				<p><?php echo get_the_author_meta( 'user_description' ); ?></p>
				<a class="grve-author-read-more grve-link-text grve-heading-color grve-heading-hover-color" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
					<?php
						if( !empty( $author_info_link_text ) ) {
							echo esc_html( $author_info_link_text ) . '  ';
						}
						the_author();
					?>
				</a>
			</div>
		</div>
	</div>
</div>