<?php
/*
*	Loop Post Style 1 Gallery Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_media = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'media_area' ) );
$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$show_categories = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'categories_visibility' ) );
$categories_mode = impeka_grve_array_value( $blog_params, 'categories_mode', 'all' );
$categories_mode = impeka_grve_array_value( $blog_params, 'categories_mode', 'all' );
$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );
$image_prio = impeka_grve_array_value( $blog_params, 'image_prio', 'no' );

?>
<div class="grve-post-item grve-style-1 grve-format-gallery">
	<div class="grve-post-item-inner">
		<div class="grve-post-top">
			<?php if ( $show_media && has_post_thumbnail() ) { ?>
			<div class="grve-post-media grve-radius-<?php echo esc_attr( $radius ); ?> grve-shadow-<?php echo esc_attr( $shadow ); ?>">
				<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
				<?php impeka_grve_print_post_feature_image( $blog_params ); ?>
			</div>
			<?php } ?>
			<?php if ( $show_categories ) { ?>
			<div class="grve-post-category grve-small-text"><?php impeka_grve_print_post_loop_meta( 'categories-' . $categories_mode ); ?></div>
			<?php } ?>
			<div class="grve-post-content">
				<?php if ( $show_date ) { ?>
				<div class="grve-post-date grve-small-text"><span><?php impeka_grve_print_post_loop_meta( 'date' ); ?></span></div>
				<?php } ?>
				<?php impeka_grve_loop_post_title_link( $blog_params ); ?>
				<div class="grve-post-exerpt" itemprop="articleBody">
					<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
				</div>
			</div>
		</div>
		<?php get_template_part( 'templates/post/meta/loop-post-meta-style-3', '', $blog_params ); ?>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>