<?php
/*
*	Loop Post Style 1 Gallery Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$link_url = get_post_meta( get_the_ID(), '_impeka_grve_post_link_url', true );
if( empty( $link_url ) ) {
	$link_url = get_permalink();
}

$anim_bg_class = array( 'grve-post-animated-bg' );
$anim_bg_class[]  = 'grve-radius-' . $radius;
$anim_bg_class[]  = 'grve-shadow-' . $shadow;
$anim_bg_class_string = implode( ' ', $anim_bg_class );


?>
<div class="grve-post-item grve-style-1 grve-format-link">
	<div class="grve-post-item-inner">
		<div class="grve-post-content-wrapper">
			<div class="grve-post-content">
				<?php impeka_grve_print_post_icon_format('link'); ?>
				<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
				<?php impeka_grve_loop_post_title( $blog_params ); ?>
				<?php impeka_grve_loop_post_link_text(); ?>
				<div class="grve-post-url grve-post-small-text"><?php echo esc_url( $link_url ); ?></div>
			</div>
		</div>
		<div class="<?php echo esc_attr( $anim_bg_class_string ); ?>"></div>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>