<?php
/*
*	Loop Post Style 3 Video Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$show_categories = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'categories_visibility' ) );
$categories_mode = impeka_grve_array_value( $blog_params, 'categories_mode', 'all' );
$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$heading_color = impeka_grve_array_value( $blog_params, 'heading_color', 'default' );
$text_color = impeka_grve_array_value( $blog_params, 'text_color', 'default' );
$meta_color = impeka_grve_array_value( $blog_params, 'meta_color', 'default' );
$bg_color = impeka_grve_array_value( $blog_params, 'bg_color', 'default' );

$custom_overview = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'custom_overview' ) );
$overview_style = impeka_grve_post_meta( '_impeka_grve_post_overview_style' );
if( $custom_overview  && 'style-3' == $overview_style) {
	$heading_color = impeka_grve_post_meta( '_impeka_grve_post_overview_heading_color', $heading_color );
	$text_color = impeka_grve_post_meta( '_impeka_grve_post_overview_text_color', $text_color );
	$meta_color = impeka_grve_post_meta( '_impeka_grve_post_overview_meta_color', $meta_color );
	$bg_color = impeka_grve_post_meta( '_impeka_grve_post_overview_bg_color', $bg_color );
}

$item_attributes = impeka_grve_get_indicator_atts( $blog_params );

$item_class = array( 'grve-post-item-inner' );
$item_class[]  = 'grve-radius-' . $radius;
$item_class[]  = 'grve-shadow-' . $shadow;
$item_class[]  = 'grve-bg-' . $bg_color;
$item_class[]  = 'grve-text-' . $text_color;
$item_class[]  = 'grve-headings-' . $heading_color;
$item_class_string = implode( ' ', $item_class );

$item_attributes[] = 'class="' . esc_attr( $item_class_string ) . '"';

?>
<div class="grve-post-item grve-style-3 grve-format-video">
	<div <?php echo implode( ' ', $item_attributes ); ?>>
		<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
		<?php impeka_grve_print_post_overview_bg_image_container( $blog_params ); ?>
		<?php if ( $show_categories ) { ?>
		<div class="grve-post-category grve-small-text"><?php impeka_grve_print_post_loop_meta( 'categories-' . $categories_mode ); ?></div>
		<?php } ?>

		<div class="grve-post-content">
			<?php impeka_grve_print_post_icon_format('video'); ?>
			<?php if ( $show_date ) { ?>
			<div class="grve-post-date grve-small-text grve-text-<?php echo esc_attr( $text_color ); ?>"><span><?php impeka_grve_print_post_loop_meta( 'date' ); ?></span></div>
			<?php } ?>
			<?php impeka_grve_loop_post_title( $blog_params ); ?>
			<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
		</div>
		<?php get_template_part( 'templates/post/meta/loop-post-meta-style-3', '', $blog_params ); ?>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>
