<?php
/*
*	Product Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	//return;
}

$product_params = isset( $args ) ? $args : array();

extract( $product_params );

//Second Image Classes
$image_classes = array();
$image_classes[] = 'attachment-' . $image_size;
$image_classes[] = 'size-' . $image_size;
$image_classes[] = 'grve-product-thumbnail-second';
$image_class_string = implode( ' ', $image_classes );

//Second Product Image
$attachment_ids = $product->get_gallery_image_ids();

$product_thumb_second_id = '';

if ( $attachment_ids ) {
	$loop = 0;
	foreach ( $attachment_ids as $attachment_id ) {
		$image_link = wp_get_attachment_url( $attachment_id );
		if (!$image_link) {
			continue;
		}
		$loop++;
		$product_thumb_second_id = $attachment_id;
		if ($loop == 1) {
			break;
		}
	}
}

//Second Image Classes
$content_classes = array( 'grve-content' );
if ( 'default' != $text_color ) {
	$content_classes[] = 'grve-text-' . $text_color;
}
$content_class_string = implode( ' ', $content_classes );
?>
<div class="grve-hover-item grve-product-<?php echo esc_attr( $hover_style ); ?>">
	<?php woocommerce_show_product_loop_sale_flash(); ?>
	<?php if ( 'quick-view' == $link_type ) { ?>
		<a class="grve-quick-view-link grve-text-<?php echo esc_attr( $text_color ); ?>" href="#" data-post-id="<?php echo esc_attr( get_the_ID() ); ?>">
			<svg width="30px" height="30px" viewBox="0 0 30 30">
				<path d="M15,10.5 C17.875614,10.5 20.495001,11.7070606 22.842256,14.1003452 L23.1118845,14.3817566 L23.6744875,14.9962783 L23.3724922,15.3335409 C20.8945249,18.1008884 18.0963016,19.5 15,19.5 C12.0142806,19.5 9.30572838,18.1990403 6.89422872,15.6248054 L6.62750777,15.3335409 L6.32551253,14.9962783 L6.89192463,14.3776425 C9.30388668,11.801697 12.0137855,10.5 15,10.5 Z M15,11.5 C12.4092033,11.5 10.0423929,12.58903 7.88373408,14.7878342 L7.68,15 L7.88700142,15.2153174 C9.87058195,17.2336166 12.0270038,18.3149198 14.3698984,18.4782045 L14.6905411,18.4947822 L15,18.5 C17.4798966,18.5 19.7553686,17.5019495 21.841911,15.4842763 L22.1129986,15.2153174 L22.319,15 L22.1196522,14.7914916 C20.1343308,12.7690573 17.9763507,11.6854719 15.6308294,11.5218417 L15.3098217,11.5052289 L15,11.5 Z M15,13 C16.1045695,13 17,13.8954305 17,15 C17,16.1045695 16.1045695,17 15,17 C13.8954305,17 13,16.1045695 13,15 C13,13.8954305 13.8954305,13 15,13 Z"></path>
			</svg>
			<span><?php echo esc_html( $quick_view_title ); ?></span>
		</a>
	<?php } ?>
	<div class="grve-media grve-image-hover">
		<div class="grve-bg-<?php echo esc_attr( $overlay_color ); ?> grve-hover-overlay grve-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
		<a class="grve-item-url" href="<?php echo esc_url( get_permalink() ); ?>"><span class="screen-reader-text"><?php the_title(); ?></span></a>
		<?php
			if ( has_post_thumbnail() ) {
				the_post_thumbnail( $image_size );
			} elseif ( wc_placeholder_img_src() ) {
				echo wc_placeholder_img( $image_size );
			}
			if ( 'yes' == $second_image_effect && !empty( $product_thumb_second_id ) ) {
				echo wp_get_attachment_image( $product_thumb_second_id, $image_size , "", array( 'class' => $image_class_string ) );
			}
		?>
	</div>
	<div class="grve-content">
		<div class="grve-content-inner">
			<<?php echo tag_escape( $title_heading_tag ); ?> class="grve-product-title grve-<?php echo esc_attr( $title_heading ); ?> grve-text-<?php echo esc_attr( $text_color ); ?>"><?php the_title(); ?></<?php echo tag_escape( $title_heading_tag ); ?>>
			<div class="grve-transform-wrapper grve-text-<?php echo esc_attr( $text_color ); ?>">
				<div class="grve-price-wrapper">
					<?php do_action( 'impeka_grve_woo_loop_price' ); ?>
				</div>
				<div class="grve-add-to-cart-wrapper">
					<?php do_action( 'impeka_grve_woo_loop_add_to_cart' ); ?>
				</div>
			</div>
		</div>
	</div>
</div>