<?php
/*
*	Navigation Bar Layout 1
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$nav_params = isset( $args ) ? $args : array();

$post_type = impeka_grve_array_value( $nav_params, 'post_type', 'post' );
$backlink_url = impeka_grve_array_value( $nav_params, 'backlink_url' );
$prev_post = impeka_grve_array_value( $nav_params, 'prev_post' );
$prev_post_title = impeka_grve_array_value( $nav_params, 'prev_post_title' );
$prev_post_text = impeka_grve_array_value( $nav_params, 'prev_post_text' );
$next_post = impeka_grve_array_value( $nav_params, 'next_post' );
$next_post_title = impeka_grve_array_value( $nav_params, 'next_post_title' );
$next_post_text = impeka_grve_array_value( $nav_params, 'next_post_text' );
$skin_assets = impeka_grve_array_value( $nav_params, 'skin_assets' );

?>

<div id="grve-<?php echo esc_attr( $post_type ); ?>-bar" class="grve-navigation-bar grve-layout-1" data-header-color="<?php echo esc_attr( $skin_assets ); ?>">
	<div class="grve-container">
		<div class="grve-bar-item">
			<div class="grve-nav-item grve-prev">
				<?php if ( is_a( $prev_post, 'WP_Post' ) ) { ?>
					<a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>">
						<?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?>
						<div class="grve-title-wrapper">
							<div class="grve-subtitle grve-link-text"><?php echo esc_html( $prev_post_text ); ?></div>
							<div class="grve-title">
								<?php echo esc_html( $prev_post_title ); ?>
							</div>
						</div>
					</a>
				<?php } ?>
			</div>
			<?php if ( !empty( $backlink_url ) ) { ?>
				<div class="grve-backlink">
					<a href="<?php echo esc_url( $backlink_url ); ?>">
						<?php echo impeka_grve_get_svg_icon( 'backlink'); ?>
					</a>
				</div>
			<?php } ?>
			<div class="grve-nav-item grve-next">
				<?php if ( is_a( $next_post, 'WP_Post' ) ) { ?>
					<a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>">
						<div class="grve-title-wrapper">
							<div class="grve-subtitle grve-link-text"><?php echo esc_html( $next_post_text ); ?></div>
							<div class="grve-title">
								<?php echo esc_html( $next_post_title ); ?>
							</div>
						</div>
						<?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?>
					</a>
				<?php } ?>
			</div>
		</div>
	</div>
</div>