<?php
/*
*	Navigation Bar Layout 2
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$nav_params = isset( $args ) ? $args : array();

$post_type = impeka_grve_array_value( $nav_params, 'post_type', 'post' );
$backlink_url = impeka_grve_array_value( $nav_params, 'backlink_url' );
$prev_post = impeka_grve_array_value( $nav_params, 'prev_post' );
$prev_post_title = impeka_grve_array_value( $nav_params, 'prev_post_title' );
$prev_post_img_url = impeka_grve_array_value( $nav_params, 'prev_post_img_url' );
$next_post = impeka_grve_array_value( $nav_params, 'next_post' );
$next_post_title = impeka_grve_array_value( $nav_params, 'next_post_title' );
$next_post_img_url = impeka_grve_array_value( $nav_params, 'next_post_img_url' );


$header_group = impeka_grve_global_param( 'header_group' );
$header_style = impeka_grve_global_param( 'header_style' );

$nav_classes = array( 'grve-navigation-bar', 'grve-layout-2', 'grve-border' );
if ( 'side' == $header_group || ( 'offcanvas' == $header_group && 'style-2' == $header_style  ) ) {
	$nav_classes[] = 'grve-position-left-auto';
}
$nav_class_string = implode( ' ', $nav_classes );

?>
<div id="grve-<?php echo esc_attr( $post_type ); ?>-bar" class="<?php echo esc_attr( $nav_class_string ); ?>">
	<?php if ( is_a( $prev_post, 'WP_Post' ) ) { ?>
	<a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>" class="grve-nav-item grve-prev" aria-label="<?php echo get_the_title( $prev_post->ID ); ?>">
		<div class="grve-arrow">
			<?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?>
		</div>
		<div class="grve-media">
			<?php if( !empty( $prev_post_img_url ) ) { ?>
			<div class="grve-inner">
				<div class="grve-title grve-link-text"><?php echo esc_html( $prev_post_title ); ?></div>
				<div class="grve-nav-image" style="background-image: url(<?php echo esc_url( $prev_post_img_url ); ?>);"></div>
			</div>
			<?php } ?>
		</div>
	</a>
	<?php } ?>
	<?php if ( !empty( $backlink_url ) ) { ?>
		<div class="grve-backlink">
			<a href="<?php echo esc_url( $backlink_url ); ?>">
				<?php echo impeka_grve_get_svg_icon( 'backlink'); ?>
			</a>
		</div>
	<?php } ?>
	<?php if ( is_a( $next_post, 'WP_Post' ) ) { ?>
	<a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>" class="grve-nav-item grve-next" aria-label="<?php echo get_the_title( $next_post->ID ); ?>">
		<div class="grve-arrow">
			<?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?>
		</div>
		<div class="grve-media">
			<?php if( !empty( $next_post_img_url ) ) { ?>
			<div class="grve-inner">
				<div class="grve-title grve-link-text"><?php echo esc_html( $next_post_title ); ?></div>
				<div class="grve-nav-image" style="background-image: url(<?php echo esc_url( $next_post_img_url ); ?>);"></div>
			</div>
			<?php } ?>
		</div>
	</a>
	<?php } ?>
</div>
