<?php
/*
*	Quick View Product Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$params = isset( $args ) ? $args : array();
$post_id = impeka_grve_array_value( $params, 'post_id' );

$current_product = null;
if ( function_exists('wc_get_product') ) {
	$current_product = wc_get_product( $post_id );
}
if ( !$current_product ) {
	return;
}

$img_url = '';
if ( has_post_thumbnail( $post_id ) ) {
	$post_thumbnail_id = get_post_thumbnail_id( $post_id );
	$img_src = wp_get_attachment_image_src( $post_thumbnail_id, 'large' );
	if( $img_src ) {
		$img_url = $img_src[0];
	}
}

$title = impeka_grve_admin_post_meta( $post_id, '_impeka_grve_quickview_title', get_the_title( $post_id ) );
$text = impeka_grve_admin_post_meta( $post_id, '_impeka_grve_quickview_text', impeka_grve_excerpt_quick_view( $post_id ) );
$link_text = impeka_grve_option( 'product_quickview_link_text' );
$link_text = impeka_grve_admin_post_meta( $post_id, '_impeka_grve_quickview_link_text', $link_text );
$close_color = impeka_grve_option( 'quick_view_close_color', 'black' );
?>
<div id="grve-product-quick-view" class="grve-quick-view-modal">
	<?php impeka_grve_print_close_icon( $close_color ); ?>
	<?php if ( !empty( $img_url ) ) { ?>
	<div class="grve-quick-view-media">
		<div class="grve-mask"></div>
		<div class="grve-inner">
			<div class="grve-background-wrapper">
				<div class="grve-bg-image" style="background-image: url(<?php echo esc_url( $img_url  ); ?>);"></div>
			</div>
		</div>
	</div>
	<?php } ?>
	<div class="grve-quick-view-description">
		<div class="grve-price-wrapper">
		<?php if ( $price_html = $current_product->get_price_html() ) : ?>
			<span class="price grve-h6"><?php echo wp_kses_post( $price_html ); ?></span>
		<?php endif; ?>
		</div>
		<div class="grve-title grve-h5"><?php echo wp_kses_post( $title ); ?></div>
		<div><?php echo do_shortcode( $text ); ?></div>
		<a href="<?php echo esc_url(  get_permalink( $post_id ) ); ?>" class="grve-btn-text grve-btn-only-text grve-btn-medium grve-with-svg-icon-arrow-2">
			<div class="grve-btn-inner">
				<span><?php echo esc_html( $link_text ); ?></span>
				<div class="grve-btn-svg-icon">
					<?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?>
				</div>
			</div>
		</a>
	</div>
</div>