<?php
/*
*	Social Bar Layout 2
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$social_params = isset( $args ) ? $args : array();

$post_type = impeka_grve_array_value( $social_params, 'post_type', 'post' );
$social_email = impeka_grve_array_value( $social_params, 'social_email' );
$social_facebook = impeka_grve_array_value( $social_params, 'social_facebook' );
$social_twitter = impeka_grve_array_value( $social_params, 'social_twitter' );
$social_linkedin = impeka_grve_array_value( $social_params, 'social_linkedin' );
$social_pinterest = impeka_grve_array_value( $social_params, 'social_pinterest' );
$social_reddit = impeka_grve_array_value( $social_params, 'social_reddit' );
$social_tumblr = impeka_grve_array_value( $social_params, 'social_tumblr' );
$social_likes = impeka_grve_array_value( $social_params, 'social_likes' );
$social_title = impeka_grve_array_value( $social_params, 'social_title' );

$post_id = get_the_ID();
$post_permalink = get_permalink();
$post_title = get_the_title();
$social_email_string = 'mailto:?subject=' . $post_title . '&body=' . $post_title . ': ' . $post_permalink;

?>
<div id="grve-<?php echo esc_attr( $post_type ); ?>-social-bar" class="grve-social-bar grve-layout-2">
	<?php if ( !empty( $social_title ) ) { ?>
	<div class="grve-socials-bar-title grve-h6 grve-heading-color"><?php echo wp_kses_post( $social_title ); ?></div>
	<?php } ?>
	<ul class="grve-bar-socials grve-h6 grve-heading-color">
		<?php if ( !empty( $social_email  ) ) { ?>
		<li><a href="<?php echo esc_url( $social_email_string ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-email">Email</a></li>
		<?php } ?>
		<?php if ( !empty( $social_facebook  ) ) { ?>
		<li><a href="<?php echo esc_url( $post_permalink ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-facebook">Facebook</a></li>
		<?php } ?>
		<?php if ( !empty( $social_twitter  ) ) { ?>
		<li><a href="<?php echo esc_url( $post_permalink ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-twitter">Twitter</a></li>
		<?php } ?>
		<?php if ( !empty( $social_linkedin  ) ) { ?>
		<li><a href="<?php echo esc_url( $post_permalink ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-linkedin">LinkedIn</a></li>
		<?php } ?>
		<?php if ( !empty( $social_pinterest  ) ) { ?>
		<li><a href="<?php echo esc_url( $post_permalink ); ?>" title="<?php echo esc_attr( $post_title ); ?>" data-pin-img="<?php echo esc_url( impeka_grve_get_thumbnail_url() ); ?>" class="grve-social-share-pinterest">Pinterest</a></li>
		<?php } ?>
		<?php if ( !empty( $social_reddit ) ) { ?>
		<li><a href="<?php echo esc_url( $post_permalink ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-reddit">Reddit</a></li>
		<?php } ?>
		<?php if ( !empty( $social_tumblr ) ) { ?>
		<li><a href="<?php echo esc_url( $post_permalink ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-tumblr">Tumblr</a></li>
		<?php } ?>
		<?php if ( !empty( $social_likes  ) ) { ?>
		<li><a href="#" class="grve-like-counter-link <?php echo impeka_grve_likes( $post_id, 'status' ); ?>" data-post-id="<?php echo esc_attr( $post_id ); ?>"><?php echo impeka_grve_get_svg_icon('heart'); ?><span class="grve-like-counter"><?php echo impeka_grve_likes( $post_id, 'number' ); ?></span></a></li>
		<?php } ?>
	</ul>
</div>