<?php
/*
*	Loop Carousel Style 1
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$item_params = isset( $args ) ? $args : array();

$type = impeka_grve_array_value( $item_params, 'type' );
$name = impeka_grve_array_value( $item_params, 'name' );
$identity = impeka_grve_array_value( $item_params, 'identity' );
$title_color = impeka_grve_array_value( $item_params, 'title_color', 'black'  );
$text_color = impeka_grve_array_value( $item_params, 'text_color', 'black' );
$bg_color = impeka_grve_array_value( $item_params, 'bg_color', 'white' );
$radius = impeka_grve_array_value( $item_params, 'radius', '3' );
$show_image = impeka_grve_array_value( $item_params, 'show_image' );
$show_title = impeka_grve_array_value( $item_params, 'show_title' );
$heading_tag = impeka_grve_array_value( $item_params, 'heading_tag' );
$heading = impeka_grve_array_value( $item_params, 'heading' );
$radius = impeka_grve_array_value( $item_params, 'radius' );
$shadow = impeka_grve_array_value( $item_params, 'shadow' );

// Item Classes
$item_classes = array( 'grve-testimonial-item', 'grve-style-4'  );
$item_classes[] = 'grve-text-' . esc_attr( $text_color );
$item_classes[] =  'grve-bg-' . esc_attr( $bg_color );
$item_classes[] = 'grve-radius-' . esc_attr( $radius );
if( 'advanced' == $type || 'masonry' == $type || 'grid' == $type ) {
	$item_classes[] = 'grve-shadow-' . esc_attr( $shadow );
}
$item_class_string = implode( ' ', $item_classes );

?>

<div class="<?php echo esc_attr( $item_class_string ); ?>">
	<div class="grve-testimonial-inner">
		<div class="grve-testimonial-content">
			<?php get_template_part( 'templates/testimonial/testimonial-rating', '', $item_params ); ?>
			<?php if ( impeka_grve_is_enabled( $show_title ) ) { ?>
				<<?php echo tag_escape( $heading_tag ); ?> class="grve-title grve-text-<?php echo esc_attr( $title_color ); ?> grve-<?php echo esc_attr( $heading ); ?>"><?php the_title(); ?></<?php echo tag_escape( $heading_tag ); ?>>
			<?php } ?>
			<?php echo apply_filters('impeka_grve_the_content', get_the_content() ); ?>
		</div>
		<div class="grve-testimonial-meta">
			<?php if ( impeka_grve_is_enabled( $show_image ) && has_post_thumbnail() ) { ?>
				<div class="grve-testimonial-thumb"><?php the_post_thumbnail( 'thumbnail' ); ?></div>
			<?php } ?>
			<div class="grve-testimonial-name-wrapper">
				<span class="grve-testimonial-name grve-link-text grve-text-<?php echo esc_attr( $title_color ); ?>" data-title-hover="<?php echo esc_attr( $name ); ?>"><?php echo esc_html( $name ); ?></span>
				<span class="grve-identity grve-small-text"><?php echo esc_html( $identity ); ?></span>
			</div>
		</div>
	</div>
</div>